#include <SDL.h>
#include <stdio.h>
#include <main.h>

void PutPixel_l( int x, int y, Uint8 R, Uint8 G, Uint8 B)
{
  PutPixel_p(lpx(x), lpy(y), R, G, B);
}

void Line_l(int old_x, int old_y, int x, int y, int R, int G, int B)
{
  Line_p(lpx(old_x), lpy(old_y), lpx(x), lpy(y), R, G, B);
}

void DrawAxes()
{
  Correctminy();
  int y = Getmaxy_p();
  int x = Getmaxx_p();
  int x_l=Getmaxx_l();

  int stepx = GetStepX(x_l);

  for(int n=stepx; n<x_l+stepx; n+=stepx) // x_
  {
    int x = lpx(n);
    Line_p(x,BORDER_R,x,y-BORDER_D,160,160,160);
    Line_p(x,y-BORDER_D+2,x,y-BORDER_D-2,0,0,0);
  }

  int step=stepx;
  if((lpx(stepx)-lpx(0)<25))
    step=2*stepx;
  for(int n=step; n<=x_l; n+=step) // x_
  {
    int x = lpx(n);
    PrintInt(x-4,y-BORDER_D+4,n);
  }

  int ymax_l = Getmaxy_l();
  int ymin_l = Getminy_l();

  int stepy = GetStepY(ymin_l, ymax_l);

  x = Getmaxx_p()-BORDER_R;
  for(int n=ymin_l; n<=ymax_l+stepy; n+=stepy) // y_
  {
    int y = lpy(n);
    Line_p(BORDER_L,y,x,y,160,160,160);
    Line_p(BORDER_L-2,y,BORDER_L+2,y,0,0,0);
    PrintInt(BORDER_L-27,y-4,n);
  }
  y = Getmaxy_p()-BORDER_D;
  //x = Getmaxx_p()-BORDER_R;

  Line_p(x,y,x-5,y-2,0,0,0);
  Line_p(x,y,x-5,y+2,0,0,0);

  Line_p(BORDER_L,BORDER_R,BORDER_L+2,BORDER_R+5,0,0,0);
  Line_p(BORDER_L,BORDER_R,BORDER_L-2,BORDER_R+5,0,0,0);

  y = Getmaxy_p();
  x = Getmaxx_p();
  Line_p(BORDER_L,BORDER_R,BORDER_L,y-BORDER_R,0,0,0); // Y
  Line_p(BORDER_L-5,y-BORDER_D,x-BORDER_R,y-BORDER_D,0,0,0);   // X

  int av, disp;
  GetAverages(&av, &disp);
  PrintInt_b(Getmaxx_p()-54,4,av);
  Print(Getmaxx_p()-26,4,"+-");
  PrintInt_b(Getmaxx_p()-12,4,disp);

}
