#include <SDL.h>
#include <stdio.h>
#include <unistd.h>
#include <main.h>

int main(int argc, char **argv)
{

  if(argc!=1)
    return usage();
  (void)(argv);

  SDL_Event event;
  volatile bool loop=true;

  void *loopptr=(void*)&loop;

  SDL_Thread *my_thread;

  if(!all_init())
    return -1;


  my_thread = SDL_CreateThread(&in_thread,loopptr);

  draw_scene();
  while(SDL_WaitEvent(&event))
  {
    if(!loop)
      SDL_Quit();
    loop = process_message(&event);
    if(!loop)
      SDL_Quit();
  }
  //fprintf(stderr,"kill thread..\n");
  SDL_KillThread(my_thread);
  //fprintf(stderr,"save data:\n");
  dump_data();
  //fprintf(stderr,"done.\n");
  return 0;
}
