#include <SDL.h>
#include <stdio.h>
#include <main.h>

static SDL_Surface *screen=NULL;
static char deftitle[]="";

static int *samples=NULL;
static int samples_cnt=0;
static int samples_size=4;
static int samples_min=0;
static int samples_max=0;

//int divider=8;

void GetAverages(int *av, int *disp)
{
  int sum=0;
  int min = samples[samples_cnt-1];
  int max = min;

  for(int i=samples_cnt - 10; i<samples_cnt; i++)
  {
    int n = samples[i];
    sum+=n;
    if(n<min)
      min =n;
    if(n>max)
      max =n;
  }
  *av=sum/10;
  *disp=(max-min)/2;
}

void dump_data()
{
  for(int i=0;i<samples_cnt;i++)
    printf("%i\n",samples[i]);
}

void Correctminy()
{
  int d = GetStepY(samples_min, samples_max);
  samples_min /=d;
  samples_min *=d;
}

int Getmaxx_l()
{
  return samples_cnt;
}

int Getmaxy_l()
{
  return samples_max;
}

int Getminy_l()
{
  return samples_min;
}

int lpx(int x)
{
  int s = samples_cnt;
  if(s>1)s--;

  int ret = BORDER_L + ((screen->w-BORDER_R-BORDER_L-10)*x)/
                        (s + GetStepX(samples_cnt));
  if(ret<0)
    fprintf(stderr,"x<0! x=%i\n",ret);
  if(ret>=screen->w)
    fprintf(stderr,"x>=w! x=%i\n",ret);
  return ret;
}

int lpy(int y)
{
  y-=samples_min;
  int dy=samples_max-samples_min + GetStepY(samples_min, samples_max);
  if(dy==0)
    return screen->h/2;
  y = (y *(screen->h - BORDER_R-BORDER_L))/(dy);
  int ret = screen->h-y-BORDER_D;
  if(ret<0)
    fprintf(stderr, "y<0! y=%i\n",ret);
  if(ret>=screen->h)
    fprintf(stderr, "y>=h! y=%i\n",ret);
  return ret;
}

void add_data(int value)
{
  if(samples==NULL)
  {
    samples=(int*)malloc(sizeof(int)*samples_size);
    samples_max=value;
    samples_min=value;
  }
  if(samples_cnt>=samples_size)
  {
    samples_size*=2;
    samples=(int*)realloc(samples, sizeof(int)*samples_size);
  }
  samples[samples_cnt]=value;
  samples_cnt++;
  if(value>samples_max)
  {
    samples_max=value;
  }
  if(value<samples_min)
  {
    samples_min=value;
  }
}

void PutPixel_p( int x, int y, Uint8 R, Uint8 G, Uint8 B)
{
  if(x<0) return;
  if(y<0) return;
  if(x>screen->w) return;
  if(y>screen->h) return;

  Uint32 color = SDL_MapRGB(screen->format, R, G, B);
  Uint32 *bufp;
  bufp = (Uint32 *)screen->pixels + y*screen->pitch/4 + x;
  *bufp = color;
}

void Slock()
{
  if ( SDL_MUSTLOCK(screen) )
    SDL_LockSurface(screen);
}

void Sulock()
{
  if ( SDL_MUSTLOCK(screen) )
    SDL_UnlockSurface(screen);
}

int Getmaxx_p()
{
  return screen->w;
}

int Getmaxy_p()
{
  return screen->h;
}

int max(int a, int b)
{
  if(a>b) return a;
  return b;
}

void Line_p(int old_x, int old_y, int x, int y, int R, int G, int B)
{
  int dx=x-old_x;
  int dy=y-old_y;

  double steps = max(abs(dx),abs(dy));

  for( int i=0;i<=steps;i++)
  {
    double x1=((old_x*i)+(x*(steps-i))+steps/2)/steps;
    double y1=((old_y*i)+(y*(steps-i))+steps/2)/steps;
    PutPixel_p(x1,y1,R,G,B);
  }
}

void draw_scene()
{
  SDL_Rect rect;
  rect.x=0;
  rect.y=0;
  rect.w=screen->w;
  rect.h=screen->h;

  Slock();
  SDL_FillRect(screen,&rect,SDL_MapRGB(screen->format, 224, 224, 224));
  DrawAxes();
  for(int x=1; x < samples_cnt; x++)
  {
    Line_l(x-1,samples[x-1],x,samples[x],0,192,0);
  }
  Sulock();
  SDL_Flip(screen);
}

bool all_init()
{
  char *st;
  char *title;
  int sizex=800, sizey=480;

  title = getenv("title");
  if(!title)
  {
    title=deftitle;
  }

  st = getenv("sizex");
  if(st)
  {
    sscanf(st,"%i",&sizex);
  }

  st = getenv("sizey");
  if(st)
  {
    sscanf(st,"%i",&sizey);
  }

//  st = getenv("divider");
//  if(st)
//  {
//    sscanf(st,"%i",&divider);
//  }

  //fprintf(stderr, "screen %i x %i\n", sizex, sizey);

  if((SDL_Init(SDL_INIT_VIDEO)<0))
  {
    fprintf(stderr,"Could not initialize SDL: %s.\n", SDL_GetError());
    return false;
  }

  screen = SDL_SetVideoMode(
            sizex, sizey, 32, 
            SDL_HWSURFACE|SDL_DOUBLEBUF|SDL_RESIZABLE);
  if(screen==NULL)
  {
    fprintf(stderr,"Unable to set %i x %i video: %s\n", sizex,sizey, SDL_GetError());
    return false;
  }
  SDL_WM_SetCaption(title,title);

  return initfont();
}

void resize(int w, int h)
{
  screen = SDL_SetVideoMode( w, h, 32,
       SDL_HWSURFACE|SDL_DOUBLEBUF|SDL_RESIZABLE);
}

bool process_message(SDL_Event *event)
{
  switch(event->type)
  {
    case SDL_QUIT:
      return false;
    case SDL_KEYDOWN:
      if ( event->key.keysym.sym == SDLK_ESCAPE )
        return false;
      return true;
    case SDL_VIDEORESIZE:
      resize(event->resize.w, event->resize.h);
      return true;
    case SDL_VIDEOEXPOSE:
      draw_scene();
      return true;
    case SDL_ACTIVEEVENT:
      if(event->active.gain==1)
        draw_scene();
      return true;
    case SDL_USEREVENT:
        draw_scene();
        return true;
  }
  return true;
}


bool Print(int x, int y, const char *str)
{
  return Print_l(screen, x, y, str);
}

bool PrintInt(int x, int y, int value)
{
  char str[16];
  //SDL_Rect rect;

  sprintf(str,"%i",value);
  //rect.x=x;
  //rect.y=y;
  //rect.w=strlen(str)*10;
  //rect.h=10;

  //Slock();
  //SDL_FillRect(screen,&rect,SDL_MapRGB(screen->format, 224, 224, 224));
  //Sulock();
  return Print_l(screen, x, y, str);
}

bool PrintInt_b(int x, int y, int value)
{
  char str[16];
  SDL_Rect rect;

  sprintf(str,"%i",value);
  rect.x=x-4;
  rect.y=y-4;
  rect.w=strlen(str)*12;
  rect.h=18;

  Slock();
  SDL_FillRect(screen,&rect,SDL_MapRGB(screen->format, 224, 224, 224));
  Sulock();
  return Print_bl(screen, x, y, str);
}
