#include <SDL.h>
#include <stdio.h>
#include <math.h>
#include <main.h>

int GetStepX(int x_l)
{
  if(x_l==0)
    x_l++;
  double x = x_l;
  x /=10.0;
  int p = log10(x);
  double d = exp(p*log(10));
  x /= d; // x=1.0-9.99 , p=1,2,3, d=10,100,1000...
  int step=1;
  if(x>=2.0)step=2;
  if(x>=5.0)step=5;
  step*=d;
  if(step<1)step=1;
  return step;
}

int  GetStepY(int ymin_l, int ymax_l)
{
  int y_l = ymax_l - ymin_l;
  return GetStepX(y_l);
}
