#include <SDL.h>
#include <stdio.h>
#include <SDL_ttf.h>
#include <main.h>

static TTF_Font *font;
static TTF_Font *font_b;

bool initfont()
{
  if(TTF_Init()==-1)
  {
    fprintf(stderr,"TTF_Init: %s\n", TTF_GetError());
    return false;
  }

  char *fontname;
  fontname=getenv("font");
  if(fontname==NULL)
  {
    fprintf(stderr,"no font selected\n");
    return false;
  }
  font=TTF_OpenFont(fontname, 8);
  if(font==NULL)
  {
    fprintf(stderr,"TTF_OpenFont: %s\n", TTF_GetError());
    return false;
  }
  font_b=TTF_OpenFont(fontname, 10);
  if(font==NULL)
  {
    fprintf(stderr,"TTF_OpenFont: %s\n", TTF_GetError());
    return false;
  }
  return true;
}

bool Print_l(SDL_Surface *screen, int x, int y, const char *str)
{
  SDL_Surface *text_surface;
  SDL_Rect dstrect;
  SDL_Color color={0,0,0,0};

  text_surface=TTF_RenderText_Blended(font,str,color);
  if(text_surface==NULL)
  {
    fprintf(stderr,"Text_surface==NULL\n");
    return false;
  }

  dstrect.x=x;
  dstrect.y=y;
  dstrect.w=100;
  dstrect.h=100;
  SDL_BlitSurface(text_surface,NULL,screen,&dstrect);
  SDL_FreeSurface(text_surface);
  return true;
}

bool Print_bl(SDL_Surface *screen, int x, int y, const char *str)
{
  SDL_Surface *text_surface;
  SDL_Rect dstrect;
  SDL_Color color={0,0,0,0};

  text_surface=TTF_RenderText_Blended(font_b,str,color);
  if(text_surface==NULL)
  {
    fprintf(stderr,"Text_surface==NULL\n");
    return false;
  }

  dstrect.x=x;
  dstrect.y=y;
  dstrect.w=100;
  dstrect.h=100;
  SDL_BlitSurface(text_surface,NULL,screen,&dstrect);
  SDL_FreeSurface(text_surface);
  return true;
}
