#include <SDL.h>
#include <stdio.h>
#include <unistd.h>
#include <main.h>

int usage()
{
  fprintf(stderr,
  "Overview.\n"
  "graph is simple SDL program for realtime visualization of any data. "
  "It reads data from stdin, plot graph data(t). "
  "After press ESC, all accumulated data will be printed to stdout "
  "in ASCII human-readable format, each sample from new line.\n"
  "\n"
  "Usage:\n"
  "All parameters are gets from environment\n"
  "sizex, sizey - initial size of graph window\n"
  "title - title of window\n"
  "font - path-to-ttf-file\n"
  "divider - how many samples accumulate before redraw screen\n"
  "\n"
  "example of batch file:\n"
  "\n"
  "#! /bin/bash\n"
  "export sizex=800\n"
  "export sizey=600\n"
  "export title=\"very simple graph\"\n"
  "export font=\"font.ttf\"\n"
  "export divider=120\n"
  "stty -F /dev/ttyUSB0 clocal -icrnl igncr -crtscts speed 38400\n"
  "cat /dev/ttyUSB0|./graph > data.log\n"
  "\n"
  );
  return 0;
}

